<?php
session_start();
include("../kuku_acrown.php"); // Must define $kurn (mysqli)

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['hdjs-ejd'], $_POST['learn-qui-kly'])) {
    $token = $_POST['learn-qui-kly'] ?? '';

    // ✅ Strict token check
    if (
        hash_equals($_SESSION['_yedawabonimiyana947383883'] ?? '', $token) ||
        hash_equals($_SESSION['_yedawabonimiyana463838'] ?? '', $token)
    ) {
        $contract   = $_SESSION['currrent_contractx'] ?? null;
        $type_nmv   = clean('type-qwsx', $kurn);
        $course_nmv = clean('course-qwsx', $kurn);
        $code_nmv   = clean('code-qwsx', $kurn);
        $img_nmv    = clean('img-qwsx', $kurn);
        $dest_nmv   = clean('dest-qwsx', $kurn);
        $time_nmv   = time();

        if ($contract) {
            // ✅ Prepared statement for SELECT
            $stmt = $kurn->prepare("SELECT id FROM bookmark_jkxm WHERE contract_code = ?");
            $stmt->bind_param("s", $contract);
            $stmt->execute();
            $stmt->store_result();
            $bkm_num = $stmt->num_rows;
            $stmt->close();

            if ($bkm_num < 1) {
                // ✅ Prepared statement for INSERT
                $stmt = $kurn->prepare("
                    INSERT INTO bookmark_jkxm (tp, course, ccode, contract_code, last_updated, course_img)
                    VALUES (?, ?, ?, ?, ?, ?)
                ");
                $stmt->bind_param("isssis", $type_nmv, $course_nmv, $code_nmv, $contract, $time_nmv, $img_nmv);
                $stmt->execute();
                $stmt->close();
            } else {
                // ✅ Prepared statement for UPDATE
                $stmt = $kurn->prepare("
                    UPDATE bookmark_jkxm SET ccode = ? WHERE contract_code = ?
                ");
                $stmt->bind_param("ss", $code_nmv, $contract);
                $stmt->execute();
                $stmt->close();
            }

            // ✅ Redirect (only allow internal paths, no external links)
            if (filter_var($dest_nmv, FILTER_VALIDATE_URL) === false) {
                header("Location: " . htmlspecialchars($dest_nmv, ENT_QUOTES, 'UTF-8'));
                exit;
            } else {
                header("Location: " . htmlspecialchars($dest_nmv, ENT_QUOTES, 'UTF-8'));
                exit;
            }
        } else {
            header("Location: " . htmlspecialchars($dest_nmv, ENT_QUOTES, 'UTF-8'));
            exit;
        }
    } else {
        header("Location: " . htmlspecialchars($dest_nmv, ENT_QUOTES, 'UTF-8'));
        exit;
    }
} else {
    header("Location: " . htmlspecialchars($dest_nmv, ENT_QUOTES, 'UTF-8'));
    exit;
}
?>
